'use client'
import Header from '@/app/Components/Home/Header';
import Sidebar from '@/app/Components/Home/Sidebar';
import apiRequest from '@/app/lib/InterceptorAxios/axios';
import { decryptData } from '@/app/utils/DecryptData';
import axios from 'axios';
import { getCookie } from 'cookies-next';
import { useRouter } from 'next/navigation';
import React, { useState, useEffect } from 'react';
import { FaSearch } from 'react-icons/fa';
import { useSelector } from 'react-redux';
import swal from 'sweetalert';
const AssignUserPage = ({ params }) => {
  const [Brand, setBrand] = useState();
  const user = useSelector((state) => state.user.userInfo);
  const [brands, setBrands] = useState([]);
  const [compulsoryUsers, setcompulsoryUsers] = useState([])
  const [searchQuery, setSearchQuery] = useState('');
  const [isSaveVisible, setIsSaveVisible] = useState(false);
  const [selectAll, setSelectAll] = useState(false); // State for "Select All"
  const [selectAllAdmin, setSelectAllAdmin] = useState(false); // State for "Select All"
  const { brandid, companyid } = params;
  const [UserId, setUserId] = useState(user.userId);
  const [SelectedCompanyId, setSelectedCompanyId] = useState(companyid)
  const [FilterUser, setFilterUser] = useState(false)
  const router = useRouter();
  const [companies, setCompanies] = useState([]);
  useEffect(() => {
    // Construct the URL using environment variable and dynamic brand ID
    const fetchBrand = async () => {
      try {
        const data = await apiRequest(`/api/brands/${brandid}`);

        setBrand(data);
              } catch (error) {
        console.error("Error fetching brand data:", error);
      }
    };

    fetchBrand();
  }, [brandid]);
  useEffect(() => {
    const token = getCookie('token');

    if (!token) {
      router.push('/login');
    } else {
      // const verifyUserRole = async () => {
      //   try {
      //     const response = await axios-post(
      //       `${process.env.NEXT_PUBLIC_API_URL}/api/auth/user-verify-role`,
      //       {},
      //       {
      //         headers: {
      //           Authorization: `Bearer ${token}`,
      //         },
      //       }
      //     );

      //     const { success, userId } = response.data;
      //     setUserId(userId);
      //   } catch (error) {
      //     console.error('Error verifying user role:', error);
      //     router.push('/login');
      //   }
      // };
      // const verifyUserRole = async () => {
      //   try {
      //     const { success, userId } = await apiRequest('/api/auth/user-verify-role', 'POST');
      //     setUserId(userId);
      //   } catch (error) {
      //     console.error('Error verifying user role:', error);
      //     router.push('/login');
      //   }
      // };
      
      // verifyUserRole();
    }
  }, []);
   // Fetch companies for the dropdown
   useEffect(() => {
    const fetchCompanies = async () => {
      try {
        const response = await apiRequest('/api/companies');
        setCompanies(response); // Assume the API returns an array of companies
      } catch (error) {
        console.error("Error fetching companies:", error);
      }
    };
    fetchCompanies();
  }, []);

  useEffect(() => {
    const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}/api/companies/brands/users-assign`);
    url.searchParams.append('brandid', brandid);
    url.searchParams.append('company_id', SelectedCompanyId);
    url.searchParams.append('filter', FilterUser);

    fetch(url)
      .then((response) => response.json())
      .then((data) =>
      {
                setBrands(data.map((user) => ({ ...user, initialAssigned: user.assigned })))
      }
      )
      .catch((error) => console.error("Error fetching data:", error));
  }, [brandid, SelectedCompanyId, FilterUser]);

  const handleDropdownChange = (e) => {
    const selectedValue = e.target.value;
    
    
        if(selectedValue == -1){
      setFilterUser(false); // Default behavior for the specific brand
      setSelectedCompanyId(companyid);
    }
    else{
      setFilterUser(true); // Filter for all companies
      setSelectedCompanyId(Number(selectedValue));
    }
   
  };
  
  useEffect(() => {
    const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}/api/companies/brands/users-assign-compulsory`);
    url.searchParams.append('brandid', brandid);
    url.searchParams.append('compulsory', true);
    url.searchParams.append('company_id', companyid);
    fetch(url)
      .then((response) => response.json())
      .then((encryptedData) =>{
  const data =        decryptData(encryptedData)
       
        
                        setcompulsoryUsers(
          data.map((user) => ({ ...user, initialAssigned: user.assigned }))
        )
      }
      )
      .catch((error) => console.error("Error fetching data:", error));
  }, [brandid, companyid]);
  

  const handleCheckChange = (userId) => {
    const updatedBrands = brands.map((user) => {
      if (user.user_id === userId) {
        return { ...user, assigned: user.assigned === 1 ? 0 : 1 };
      }
      return user;
    });
    setBrands(updatedBrands);
    setIsSaveVisible(true);
  };  const handleCheckChangeAdminusers = (userId) => {
    const updatedBrands = compulsoryUsers.map((user) => {
      if (user.user_id === userId) {
        return { ...user, assigned: user.assigned === 1 ? 0 : 1 };
      }
      return user;
    });
    setcompulsoryUsers(updatedBrands);
    setIsSaveVisible(true);
  };

  const handleSelectAll = () => {
    setSelectAll(prev => {
      const newSelectAll = !prev;
      setBrands(prevBrands =>
        prevBrands.map(brand => ({
          ...brand,
          assigned: newSelectAll ? 1 : 0,
        }))
      );
      setIsSaveVisible(true); // Show save button when selecting all
      return newSelectAll;
    });
  };const handleAdminUserSelectAll = () => {
    setSelectAllAdmin(prev => {
      const newSelectAll = !prev;
      setcompulsoryUsers(prevBrands =>
        prevBrands.map(brand => ({
          ...brand,
          assigned: newSelectAll ? 1 : 0,
        }))
      );
      setIsSaveVisible(true); // Show save button when selecting all
      return newSelectAll;
    });
  };

  // const handleSave = async () => {
  //   // Check changes for "All Users"
  //   const changedBrands = brands.filter(
  //     (user) => user.assigned !== user.initialAssigned
  //   );
  
  //   // Check changes for "Administrators"
  //   const changedCompulsoryUsers = compulsoryUsers.filter(
  //     (user) => user.assigned !== user.initialAssigned
  //   );
  
  //   // Merge all changes into a single `users` payload
  //   const mergedChanges = [...changedBrands, ...changedCompulsoryUsers];
  
  //   if (mergedChanges.length === 0) {
  //     swal("No Changes", "No changes detected to save.", "info");
  //     return;
  //   }
  
  //   const dataToSend = {
  //     brandId: brandid,
  //     company_id: companyid,
  //     createdBy: UserId,
  //     users: mergedChanges, // Single array containing both "users" and "administrators"
  //   };
  
  //   try {
  //     await axios-put(
  //       `${process.env.NEXT_PUBLIC_API_URL}/api/companies/brands/update-users-assign`,
  //       dataToSend
  //     );
  
  //     swal("Success!", "Changes saved successfully.", "success");
  
  //     // Update initial state to match the current state after saving
  //     setBrands((prev) =>
  //       prev.map((user) => ({ ...user, initialAssigned: user.assigned }))
  //     );
  //     setcompulsoryUsers((prev) =>
  //       prev.map((user) => ({ ...user, initialAssigned: user.assigned }))
  //     );
  
  //     setIsSaveVisible(false); // Hide Save button after save
  //   } catch (error) {
  //     console.error("Error updating assignments:", error);
  //     swal("Error", "Failed to save changes. Please try again.", "error");
  //   }
  // };
  
  const handleSave = async () => {
    const changedBrands = brands.filter(
      (user) => user.assigned !== user.initialAssigned
    );
  
    const changedCompulsoryUsers = compulsoryUsers.filter(
      (user) => user.assigned !== user.initialAssigned
    );
  
    const mergedChanges = [...changedBrands, ...changedCompulsoryUsers];
  
    if (mergedChanges.length === 0) {
      swal("No Changes", "No changes detected to save.", "info");
      return;
    }
  
    const dataToSend = {
      brandId: brandid,
      company_id: companyid,
      createdBy: UserId,
      users: mergedChanges,
    };
  
    try {
      await apiRequest(`/api/companies/brands/update-users-assign`,"PUT", 
        dataToSend
      );
  
      swal("Success!", "Changes saved successfully.", "success");
  
      setBrands((prev) =>
        prev.map((user) => ({ ...user, initialAssigned: user.assigned }))
      );
      setcompulsoryUsers((prev) =>
        prev.map((user) => ({ ...user, initialAssigned: user.assigned }))
      );
  
      setIsSaveVisible(false);
    } catch (error) {
      console.error("Error updating assignments:", error);
      swal("Error", "Failed to save changes. Please try again.", "error");
    }
  };
  

  const handleSearch = (e) => {
    setSearchQuery(e.target.value);
  };

  const filteredBrands = brands
  ?.filter(
    (brand) =>
      brand.user_name?.toLowerCase()?.includes(searchQuery.toLowerCase())
  )
  ?.filter(
    (brand) =>
      !compulsoryUsers.some((compUser) => compUser.user_id === brand.user_id)
  );
const filteredcompulsoryUsers = compulsoryUsers?.filter((user) =>
    compulsoryUsers.user_name?.toLowerCase()?.includes(searchQuery.toLowerCase())
  );

  return (
    <>
    
     
        <div className="container-fluid top-bar justify-content-between flex-1 d-flex">
          <div className="left-div">
          <h2>{Brand?.name}: Assign Users</h2>
          </div>
          <div className="right-div left-div">
  <h2>
    Company: {companies.find((company) => company.id === Number(companyid))?.name || "Unknown"}
  </h2>
</div>

        </div>
        <div className="container-fluid company-header">
        <div className="comp-header-row flex justify-content-between align-items-center">
      <div className="search-input-container">
        <input
          type="text"
          className="form-control search-input"
          placeholder="Search Users"
          value={searchQuery}
          onChange={handleSearch}
        />
        <FaSearch className="search-icon" />
      </div>
      {isSaveVisible && (
        <button className="btn p-btn" onClick={handleSave}>
          Save Changes
        </button>
      )}
    </div>
        </div>
        <div className="container-fluid table-container">
          <div className='container-fluid-header'>
            <h3>Administration</h3>
        <button className="btn  " onClick={handleAdminUserSelectAll}>
              {selectAllAdmin ? 'Deselect All' : 'Select All'}
            </button>
          </div>
          <table className="table table-striped mt-2">
            <thead>
              <tr>
                <th>User</th>
                <th>Pseudonym</th>
                <th>Company</th>
                <th>Assign</th>
              </tr>
            </thead>
            <tbody>
              {compulsoryUsers.map((user) => (
                <tr key={user.user_id}>
                  <td>{user.name}</td>
                  <td>{user.user_name}</td>
                  <td>{user.company_name}</td>
                  <td>
                    <input
                      type="checkbox"
                      checked={user.assigned === 1}
                      onChange={() => handleCheckChangeAdminusers(user.user_id)}
                    />
                  </td>
                </tr>
              ))}
            </tbody>
          </table> 
          <div className='container-fluid-header mb-0'>
            <h3 className='mb-0'>Users</h3>

          </div>
          <div className='container-fluid-header'>
          
         <select
  className="form-control w-25 custom-select"
  onChange={handleDropdownChange}
  value={SelectedCompanyId}
>
  <option value={0}>All Companies</option>
  {companies.map((company) => (
    <option key={company.id} value={company.id}>
      {company.name}
    </option>
  ))}
</select>

        <button className="btn  " onClick={handleSelectAll}>
              {selectAll ? 'Deselect All' : 'Select All'}
            </button>
          </div>
          <table className="table table-striped mt-2">
            <thead>
              <tr>
                <th>User</th>
                <th>Pseudonym</th>
                <th>Company</th>
                <th>Assign</th>
              </tr>
            </thead>
            <tbody>
              {filteredBrands.map((user) => (
                <tr key={user.user_id}>
                  <td>{user.name}</td>
                  <td>{user.user_name}</td>
                  <td>{user?.company_name}</td>
                  <td>
                    <input
                      type="checkbox"
                      checked={user.assigned === 1}
                      onChange={() => handleCheckChange(user.user_id)}
                    />
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
  
    </>
  );
};

export default AssignUserPage;
